﻿psiType = PMT;

//menu定义
var MENU_ADD_PROG_DESC = 1;
var MENU_ADD_ELEMENT = 2;
var MENU_VIDEO_ELEMENT = 3;
var MENU_AUDIO_ELEMENT = 4;

var menuIdArray = ["modifyTable", "addProgramDesc", "addElement", "videoElement", "audioElement", "descriptor"];
var MENU_NUM = 6;

/*************************************************
Function: 		modifyElement
Description: 	修改表信息
Input: 			无
Output:			无
Return: 		无
Others: 		无
*************************************************/
function modifyTable()
{
	actionType = SET;
	operation = OPER_TABLE;
	displayParam();
	$("#table").css("display", "");
	$("#element").css("display", "none");
	if(language == ENGLISH)
	{
		$("#editHeader").html("Table Info");
	}
	else
	{
		$("#editHeader").html("表信息");
	}	
	$("#editInfo").modal();
}

/*************************************************
Function: 		addElement
Description: 	添加音视频单元
Input: 			无
Output:			无
Return: 		无
Others: 		无
*************************************************/
function addElement()
{
	actionType = ADD;
	operation = OPER_ELEMENT;
	editElement();
}

/*************************************************
Function: 		modifyElement
Description: 	修改音视频单元信息
Input: 			无
Output:			无
Return: 		无
Others: 		无
*************************************************/
function modifyElement()
{	
	actionType = SET;
	operation = OPER_ELEMENT;
	displayParam();
	editElement();
}

/*************************************************
Function: 		modifyElement
Description: 	编辑音视频单元信息
Input: 			无
Output:			无
Return: 		无
Others: 		无
*************************************************/
function editElement()
{
	$("#table").css("display", "none");
	$("#element").css("display", "");
	if(language == ENGLISH)
	{
		$("#editHeader").html("ELement");
	}
	else
	{
		$("#editHeader").html("单元");
	}	
	$("#editInfo").modal();
}

function displayParam() 
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();

	xmlHttp.open("GET", "/goform/formIPQAM?type=" + psiType + "&cmd=" + GET + "&language=" + language + "&id=" + id + "&operation=" + operation + "&index=" + nodeIndex + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);			
			if(response != "")
			{
				data = response.split(FIRST_DELIMITER);
				if(operation == OPER_TABLE)
				{
					$("#versionNumber").val(data[0]);	
				}
				else if(operation == OPER_ELEMENT)
				{
					$("#elementType").val(data[0]);
					$("#elementPid").val(data[1]);
				}
			}			
		}
	}
	xmlHttp.send(null);	
}

function editPageApply()
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();
	
	if(paramCheck() == false)
	{
		return;
	}
	
	data = "type=" + psiType + "&cmd=" + actionType + "&language=" + language + "&id=" + id + "&operation=" + operation + "&setString=";
	data += generateData();
	
	xmlHttp.open("POST", "/goform/formIPQAM", true)
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			$.modal.close();
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == RETURN_OK)
			{
				if(actionType == ADD)
				{
					if(language == ENGLISH)
					{
						alert("Add Successfully!");
					}
					else
					{
						alert("添加成功！");
					}
				}
				else if(actionType == SET)
				{
					if(language == ENGLISH)
					{
						alert("Set Successfully!");
					}
					else
					{
						alert("设置成功！");
					}
				}				
			}
			else
			{
				alert(returnError[language][response]);
			}
			self.location.reload(true);
		}
	}
	xmlHttp.send(data);
}

/*************************************************
Function: 		deleteElement
Description: 	删除音视频单元信息
Input: 			无
Output:			无
Return: 		无
Others: 		无
*************************************************/
function deleteElement()
{
	operation = OPER_ELEMENT;
	if(language == ENGLISH)
	{
		var confirmPrompt = "Are you sure to delete the element?";
	}
	else
	{
		var confirmPrompt = "确定要删除当前单元吗？";
	}
	if(window.confirm(confirmPrompt))
	{
		deleteApply();
	}	
}

function paramCheck()
{
	var returnFlag;
	if(operation == OPER_TABLE)
	{
		returnFlag = ValidateParam($("#versionNumber"), "INT_DEC", 0, 31, "<Version Number>", "<版本号>", language);
		if(returnFlag == false)
		{
			return false;
		}
	}
	else if(operation == OPER_ELEMENT)
	{
		returnFlag = ValidateParam($("#elementType"), "INT_DEC", 0, 255, "<Element Type>", "<单元类型>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#elementPid"), "INT_DEC_HEX", 32, 8190, "<Element PID>", "<单元PID>", language);
		if(returnFlag == false)
		{
			return false;
		}
	}
	return true;
}

function generateData()
{
	var data;
	if(operation == OPER_TABLE)
	{
		data = $("#versionNumber").val();
	}
	else if(operation == OPER_ELEMENT)
	{
		if(actionType == ADD)
		{
			data = $("#elementType").val() + FIRST_DELIMITER + $("#elementPid").val();
		}
		else
		{
			data = nodeIndex + FIRST_DELIMITER +$("#elementType").val() + FIRST_DELIMITER + $("#elementPid").val();
		}		
	}	
	return data;
}